﻿//////////////////////////////////////////////
// Button.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkWinUi
#include "Component.h"

#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <functional>

/// Class ------------------------------------
	
namespace nkWinUi
{
	class DLL_WINUI_EXPORT Button : public Component
	{		
		public :
		
			// Constructor, destructor
			Button (System* system) noexcept ;
			virtual ~Button () ;

			// Callback
			void setButtonClickCallback (std::function<void (Button*)> value) ;
			std::function<void (Button*)> getButtonClickCallback () const ;

		public :

			// Statics
			static nkMemory::UniquePtr<Button> create (System* system = nullptr) ;

		protected :
		
			// Attributes
			// Callback
			std::function<void (Button*)> _buttonClickCallback ;
	} ;
}